function [skt] = sktopen(remoteip,socket,port,baud);
%[skt] = sktopen(remoteip,socket);
%[skt] = sktopen(remoteip);
%[skt] = sktopen( '192.168.1.4' ,1000);
%[skt] = sktopen( '1.4','1.1','COM4',230400 ); for serial version
%[skt] = sktopen(remoteip,localip,comport,baudrate);
% To close serial port - skt.ser=1;
% Open udp socket and get registry info from PIC/ARM
% updated for octave 3-Feb-2018 - Ian Stothers
% updated for compatibility with 32 bit mcu octave 25/may/2020 - Ian Stothers
% updated to deal with udp buffer bug in instrument-control
% 0.9.1 28/Dec/2023 - Ian Stothers
% Added registry cache for 32 bit etherrnet registry cache 23 Oct 2024 - Ian Stothers


if (nargin==0)
   remoteip='192.168.1.4';
   nargin=1;
endif

if(max(size(find(remoteip=='.')))==1)
 if (nargin==1)
   skt=sersktopen(remoteip);
 endif
 if (nargin==2)
    skt=sersktopen(remoteip,socket);
 endif
 if (nargin==3)
    skt=sersktopen(remoteip,socket,port);
 endif
 if (nargin==4)
    skt=sersktopen(remoteip,socket,port,baud);
 endif
 return;
endif

if((exist('udpport')~=3))
    pkg load instrument-control; % load the instrument control octave library
end
if (exist('udpport')~=3)
  error('Needs instrument-control toolbox');
  return;
endif
Broadcast = 0;
if (strfind(remoteip,'255')>0)
   Broadcast=1;
endif

if(nargin==2)
 skt.ip=remoteip;
 skt.udp = udpport('localport',socket);
else
 if (nargin==1)
  skt.ip = remoteip;
  minport=32000; % search socket range
  maxport=33000;
  socket=minport;
  gotone=0;
  while (gotone==0)
   try
    skt.udp = udpport('localport',socket);
    gotone=1;
   catch
    socket=socket+1;
    if (socket>maxport)
      error('no socket found');
    end
   end
  endwhile
 else
  error('sktopen needs 1 or 2 arguments - type help sktopen for details');
 endif
endif
skt.udp.Timeout=0.1 ;

skt.port=socket;

if (Broadcast==1)
  set(skt.udp,"EnableBroadcast",Broadcast);
else
 skt=udpgetinfo(skt);
endif
if (sum(instrhwinfo.ToolboxVersion=='0.9.1')==5)
  skt.max=min([skt.max 1000]); % instrument control bug workaround
endif
endfunction

function [oskt]=udpgetinfo(skt)
%function [oskt]=udpgetinfo(skt)
% Add the registry onto the skt to allow named references
% from PIC
% updated for octave 3-Feb-2018 - Ian Stothers
% updated for new instrument control api octave 28 Mar 2022- Ian Stothers
% added registry cache 23 Oct 2024 - Ian Stothers

b32_infosize=16;
b16_infosize=10;
pbuf=uint8([1 0 0 0]);
write(skt.udp,pbuf,skt.ip,skt.port);
b=[];
oskt=skt;
oskt.max=[];
oskt.bits=[];
oskt.RegAdd=[];
oskt.RegLen=[];
oklim=10;
ok=oklim; % Allow oklim retry
oskt.bits=b32_infosize; %default
while (ok>0)
   try

      flushinput(skt.udp);
      write(skt.udp,pbuf,skt.ip,skt.port);
      flushoutput(skt.udp);
      flushinput(skt.udp);
      b=double(read(skt.udp,oskt.bits));
      if (max(size(b))==b16_infosize)
           error(['16bit registry no longer supported' skt.ip]);
           return;
      end
      if (max(size(b))==b32_infosize)
         if (b(1:4)==[2 1 0 0])
            ok=-1;
            oskt.bits=32;
            oskt.max=b(4+(1:4))*(2).^(0:8:24)';
            oskt.RegAdd=b(8+(1:4))*(2).^(0:8:24)';
            oskt.RegLen=b(12+(1:4))*(2).^(0:8:24)';

          else
           error(['Could not get Registry from target at ' skt.ip]);
           return;
          end
      end
    catch
  end
    ok=ok-1;
endwhile


if (ok==0)
    error(['Retry time-out contacting '  skt.ip ]);
end
if (oskt.bits==32)
 a=oskt.RegAdd;
 len=oskt.RegLen;
 x=1;

 idx=0:255;
 idx(33)=0;
 b=double(udppeek(oskt,oskt.RegAdd,oskt.RegLen));
 a=b(0+(1:4))*(2).^(0:8:24)';
 first_ptr=b(4+(1:4))*(2).^(0:8:24)';
 first_len=b(8+(1:4))*(2).^(0:8:24)';
 first_rows=b(12+(1:4))*(2).^(0:8:24)';
 first_type=b(16+(1:4))*(2).^(0:8:24)';
 tmp=idx(b(21:len)+1);
 mt=min(find(tmp==0));
 tmp=tmp(1:mt);
 tmp1=zeros(1,32);
 tmp1(1:mt)=tmp;
 first_name=char(tmp1);

 if (first_name(find(first_name~=0))=='Reg_Name') % does firstname exist in device registry
   regname= char(udppeek(oskt,first_ptr,first_len)); % go get the name string
   regname=regname(find(regname>0)); % de-fluff it
   regname=regname(find(regname~=':'));
   regname=regname(find(regname~=' '));
   regname=['regname_' regname];

   if (exist(regname)==2) %(exist(regname)==2) % does a registry cache file of that name exist if so get it
   %read in cache
     load(regname);
   % use cached values
     oskt.ptr=cskt.ptr;
     oskt.len=cskt.len;
     oskt.rows=cskt.rows;
     oskt.type=cskt.type;
     oskt.name=cskt.name;
     oskt.hash=cskt.hash;
   else
   %read from remote unit
    while (a>0)
     b=double(udppeek(oskt,a,len));
     a=b(0+(1:4))*(2).^(0:8:24)';
     oskt.ptr(x)=b(4+(1:4))*(2).^(0:8:24)';
     oskt.len(x)=b(8+(1:4))*(2).^(0:8:24)';
     oskt.rows(x)=b(12+(1:4))*(2).^(0:8:24)';
     oskt.type(x)=b(16+(1:4))*(2).^(0:8:24)';
     tmp=idx(b(21:len)+1);
     mt=min(find(tmp==0));
     tmp=tmp(1:mt);
     tmp1=zeros(1,32);
     tmp1(1:mt)=tmp;
     oskt.name(x,:)=char(tmp1);
     oskt.hash(x)=sum(oskt.name(x,:)+0.0);
     x=x+1;
    endwhile
    % Write out skt cache
     cskt.ptr=oskt.ptr;
     cskt.len=oskt.len;
     cskt.rows=oskt.rows;
     cskt.type=oskt.type;
     cskt.name=oskt.name;
     cskt.hash=oskt.hash;
     save(regname,'cskt')
   end %(exist(regname)==2)
  else
      %read from remote unit
    while (a>0)
     b=double(udppeek(oskt,a,len));
     a=b(0+(1:4))*(2).^(0:8:24)';
     oskt.ptr(x)=b(4+(1:4))*(2).^(0:8:24)';
     oskt.len(x)=b(8+(1:4))*(2).^(0:8:24)';
     oskt.rows(x)=b(12+(1:4))*(2).^(0:8:24)';
     oskt.type(x)=b(16+(1:4))*(2).^(0:8:24)';
     tmp=idx(b(21:len)+1);
     mt=min(find(tmp==0));
     tmp=tmp(1:mt);
     tmp1=zeros(1,32);
     tmp1(1:mt)=tmp;
     oskt.name(x,:)=char(tmp1);
     oskt.hash(x)=sum(oskt.name(x,:)+0.0);
     x=x+1;
    endwhile
  end %(first_name(find(first_name~=0))=='Reg_Name')
 else %if (oskt.bits==32)
     error(['Not a 32 bit Registry' skt.ip]);
end
endfunction


function [skt] = sersktopen(remoteip,localip,comport,baudrate);
%[skt] = sersktopen(remoteip,localip,comport,baudrate);
%[skt] = sktopen( '1.4','1.1','COM4',230400 );
% Open serial socket and get registry info from STM
%  5-Jun-2023 - Ian Stothers


if((exist('udpport')~=3))
    pkg load instrument-control; % load the instrument control octave library
end
if (exist('udpport')~=3)
  error('Needs instrument-control toolbox');
  return;
 end

if(nargin<4)
 baudrate=230400;
endif
if(nargin<1)
 skt.remoteip='1.4';
else
 skt.remoteip=remoteip;
endif
if(nargin<2)
 skt.localip='1.1';
else
 skt.localip=localip;
endif
if(nargin<3)
 a=serialportlist;
 comport=char(a(end,1));
endif

skt.ip=skt.remoteip;

if(ischar(comport))
 skt.ser = serialport(comport,baudrate);
else
 skt.ser=comport;
endif
skt.ser.Timeout=0.1;

setDTR(skt.ser,0); %enable line drivers
skt=sergetinfo(skt);
endfunction

function [oskt]=sergetinfo(skt)
%function [oskt]=sergetinfo(skt)
% Add tstmhe registry onto the skt to allow named references
% from PIC

b32_infosize=16;
pp_commands;
pbuf=uint8(UDP_GET_PP_INFO);

b=[];
oskt=skt;
oskt.max=[];
oskt.bits=[];
oskt.RegAdd=[];
oskt.RegLen=[];

oskt.bits=b32_infosize; %default

ok=0;
b=sersendget(skt,pbuf,b32_infosize);
      if (max(size(b))==b32_infosize)
         if (b(1:4)==UDP_GET_PP_INFO_REPLY)
            ok=-1;
            oskt.bits=32;
            oskt.max=b(4+(1:4))*(2).^(0:8:24)';
            oskt.RegAdd=b(8+(1:4))*(2).^(0:8:24)';
            oskt.RegLen=b(12+(1:4))*(2).^(0:8:24)';
          else
           error(['Could not get Registry from target at ' skt.ip]);
           return;
          end
      end
      if (ok==0)
    error(['Retry time-out contacting '  skt.ip ]);

end


 idx=0:255;
 idx(33)=0;
 b=double(udppeek(oskt,oskt.RegAdd,oskt.RegLen));
 a=b(0+(1:4))*(2).^(0:8:24)';
 first_ptr=b(4+(1:4))*(2).^(0:8:24)';
 first_len=b(8+(1:4))*(2).^(0:8:24)';
 first_rows=b(12+(1:4))*(2).^(0:8:24)';
 first_type=b(16+(1:4))*(2).^(0:8:24)';
 tmp=idx(b(21:oskt.RegLen)+1);
 mt=min(find(tmp==0));
 tmp=tmp(1:mt);
 tmp1=zeros(1,32);
 tmp1(1:mt)=tmp;
 first_name=char(tmp1);
 first_name=char(tmp1);

 if (first_name(find(first_name~=0))=='Reg_Name') % does firstname exist in device registry
   regname= char(udppeek(oskt,first_ptr,first_len)); % go get the name string
   regname=regname(find(regname>0)); % de-fluff it
   regname=regname(find(regname~=':'));
   regname=regname(find(regname~=' '));
   regname=['regname_' regname];

   if (exist(regname)==2) %(exist(regname)==2) % does a registry cache file of that name exist if so get it
   %read in cache
     load(regname);
   % use cached values
     oskt.ptr=cskt.ptr;
     oskt.len=cskt.len;
     oskt.rows=cskt.rows;
     oskt.type=cskt.type;
     oskt.name=cskt.name;
     oskt.hash=cskt.hash;
   else
     a=oskt.RegAdd;
     len=oskt.RegLen;
     x=1;

     while (a>0)
       b=double(udppeek(oskt,a,len));
       a=b(0+(1:4))*(2).^(0:8:24)';
       oskt.ptr(x)=b(4+(1:4))*(2).^(0:8:24)';
       oskt.len(x)=b(8+(1:4))*(2).^(0:8:24)';
       oskt.rows(x)=b(12+(1:4))*(2).^(0:8:24)';
       oskt.type(x)=b(16+(1:4))*(2).^(0:8:24)';
       tmp=idx(b(21:len)+1);
       mt=min(find(tmp==0));
       tmp=tmp(1:mt);
       tmp1=zeros(1,32);
       tmp1(1:mt)=tmp;
       oskt.name(x,:)=char(tmp1);
       oskt.hash(x)=sum(oskt.name(x,:)+0.0);
       x=x+1;
      endwhile
      % Write out skt cache
      cskt.ptr=oskt.ptr;
      cskt.len=oskt.len;
      cskt.rows=oskt.rows;
      cskt.type=oskt.type;
      cskt.name=oskt.name;
      cskt.hash=oskt.hash;
      save(regname,'cskt')
    end %else
 else
     a=oskt.RegAdd;
     len=oskt.RegLen;
     x=1;

     while (a>0)
       b=double(udppeek(oskt,a,len));
       a=b(0+(1:4))*(2).^(0:8:24)';
       oskt.ptr(x)=b(4+(1:4))*(2).^(0:8:24)';
       oskt.len(x)=b(8+(1:4))*(2).^(0:8:24)';
       oskt.rows(x)=b(12+(1:4))*(2).^(0:8:24)';
       oskt.type(x)=b(16+(1:4))*(2).^(0:8:24)';
       tmp=idx(b(21:len)+1);
       mt=min(find(tmp==0));
       tmp=tmp(1:mt);
       tmp1=zeros(1,32);
       tmp1(1:mt)=tmp;
       oskt.name(x,:)=char(tmp1);
       oskt.hash(x)=sum(oskt.name(x,:)+0.0);
       x=x+1;
      endwhile

 end

endfunction



